IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_SCA_Clientes_Ult_Accesos') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_SCA_Clientes_Ult_Accesos
END
GO

CREATE PROCEDURE [dbo].[CP_SCA_Clientes_Ult_Accesos] @pId_Cliente INT
AS 

DECLARE @posicion			INT
DECLARE @longitud			INT
DECLARE @Id_Controlador		SMALLINT



CREATE TABLE #rUlt_Accesos
(Fecha	VARCHAR(10), 
Hora	VARCHAR(10), 
Resultado CHAR(1), 
Motivo VARCHAR(100), 
Acceso VARCHAR(20), 
Controlador VARCHAR(100))


INSERT INTO #rUlt_Accesos
SELECT 
TOP 10
CONVERT(VARCHAR(5), CE.Fecha, 103) AS Fecha,
CONVERT(VARCHAR(8), CE.Fecha, 108) AS Hora,
CE.Resultado,
SUBSTRING(CONVERT(VARCHAR(MAX), CE.Observacion), 1, 99) AS Motivo,
CA.Descripcion AS Acceso,
CC.Descripcion AS Controlador
FROM CD_ES CE, CD_Accesos CA, CD_Controladores CC
WHERE
CE.Id_Acceso = CA.Id_Acceso
AND CE.Id_Controlador = CC.Id_Controlador
AND CE.Id_Cliente = @pId_Cliente
ORDER BY CE.Fecha DESC


SELECT * FROM #rUlt_Accesos

DROP TABLE #rUlt_Accesos